<?php

namespace VM\ApiBundle\Command;

use Doctrine\ORM\EntityManager;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use VM\ApiBundle\Entity\Application;
use VM\ApiBundle\Entity\ApplicationRole;
use VM\ApiBundle\Entity\Method;
use VM\ApiBundle\Entity\Service;
use VM\ApiBundle\Entity\User;
use VM\ApiBundle\Services\PasswordEncoder;

class CreateNewApplicationCommand extends ContainerAwareCommand
{
    /**
     * @var OutputInterface
     */
    private $output;

    /**
     * @var InputInterface
     */
    private $input;


    private $dialog;


    protected function configure()
    {
        $this
            ->setName('sso:create:application')
            ->setDescription('Stworzenie nowej aplikacji')
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        try
        {
            $this->output = $output;
            $this->input = $input;
            $this->dialog = $this->getHelperSet()->get('dialog');
            $output->writeln('<bg=green;options=bold>Create new application</bg=green;options=bold> ');

            $symbol = '';
            $this->setValue($symbol, 'Symbol');
            $description = '';
            $this->setValue($description, 'Description', 0);
            $rolesNames = '';
            $output->writeln('Write roles to application (separated \',\')');
            $this->setValue($rolesNames, 'Roles',1);
            $rolesNames = explode(',',$rolesNames);

            $Application = $this->createApplication($symbol,$description,$rolesNames);

            $this->getEntityManager()->flush();
            $this->refreshApplication($Application);

            $this->writeApplicationData($Application);
        }
        catch(\Exception $Exception)
        {
            $output->writeln('<error>' . $Exception->getCode() . ' - ' . $Exception->getMessage() .  ' </error>');
        }
    }

    private function writeApplicationData(Application $Application)
    {
        $this->output->writeln('<bg=green;options=bold>Data:</bg=green;options=bold> ');
        $this->output->writeln('Symbol     : '.$Application->getSymbol());
        $this->output->writeln('Description: '.$Application->getDescription());
        $this->output->write('Roles      : ');
        /** @var ApplicationRole $Role */
        foreach($Application->getRoles() as $Role)
        {
            $this->output->write($Role->getSymbol().',');
        }
        $this->output->writeln('');
    }

    /**
     * @param $symbol
     * @param $description
     * @param array $rolesNames
     * @return Application
     */
    private function createApplication($symbol,$description,Array $rolesNames)
    {
        $Application = new Application();
        $Application->setSymbol($symbol);
        $Application->setDescription($description);

        if(!empty($rolesNames))
        {
            foreach($rolesNames as $roleName)
            {
                $Role = new ApplicationRole();
                $Role->setApplication($Application);
                $Role->setSymbol($roleName);
                $Role->setDescription('');

                $this->getEntityManager()->persist($Role);
                $Application->addRole($Role);
            }
        }

        return $Application;
    }

    private function refreshApplication(Application &$Application)
    {
        $this->getEntityManager()->refresh($Application);
        $applicationId = $Application->getId();
        $this->getEntityManager()->clear();

        return $Application = $this->getEntityManager()->getRepository('VMApiBundle:Application')->find($applicationId);
    }

    private function setValue(&$value,$description, $minLength = 3)
    {
        $error = false;
        do
        {
            if(strlen($value) < 3 && $error)
            {
                $this->output->writeln('Min '.$minLength.' char.');
            }
            $value = $this->dialog->ask($this->output,$description.': ');
            $error = true;
        }
        while (strlen($value) < $minLength);

        return $value;
    }

    /**
     * @return EntityManager
     */
    private function getEntityManager()
    {
        return $this->getContainer()->get('doctrine.orm.entity_manager');
    }
} 